%LIUWTCV   Write LIUQE specific data in TCV tree
% LIUWTCV(SHOT,TREE,BRANCH,L,LY,DEP) writes LIUQE specific data from LY in
% TCV SHOT TREE BRANCH. L contains ancillary data as obtained by LIUP.
% DEP is the list of node paths to be written in NODES_USED
% subnodes (used in TCV to automatically rerun LIUQE) To
% be used with MEQWTCV. See also MEQWTCV,LIUP,LIUT.
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
function liuwtcv(shot,tree,branch,~,LY,dep)
 
 %% Checks
 assert(isequal(numel(LY.t),numel(unique(LY.t))),'LY.t has some repeated values, this run cannot be stored in MDS');
 
 %%
 
 meqmdsopen(shot,tree,branch)
 
 v = meqver(); % Get meq version number
 
 put = @(node,x,f,d,u,h) meqput(node,x,f,d,u,h,v,dep);
 
 %% Algorithm outputs
 put('DELTA_Z'     ,LY.dz   ,'f',{          'TIME_FAST'},'m'    ,'Residual vertical shift (t)[m]')
 
end
