function LY = liusimpost(L,LY)
% LIUSIMPOST Post-processing actions for RTLIUQE runs
%
%  LY = liusimpost(L,LY)
%
% Attempt to make LY as close as possible to the output of an offline run.
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

nt = numel(LY.t);

%% Domain limit values
assert(L.nD==1,'RTLIUQE handling multiple domains?')
LY.F0 = LY.FA;
LY.F1 = LY.FB;

%% qA
assert(~isfield(LY,'qA'),'RTLIUQE now giving qA directly?')
if isfield(LY,'iqQ') && L.pQ(1)==0
  LY.qA = 1./LY.iqQ(1,:);
end

%% X-points
% Early RTLIUQE runs did not have X-point outputs
if ~isfield(LY,'rX')
  LY.rX = zeros(L.dimw,nt,'single');
  LY.zX = LY.rX;
  LY.FX = LY.rX;
  LY.nX = zeros(1,nt,'int32');
end

% FX,rX,zX set to NaN when not an X-point
for xX = {'rX','zX','FX'}
  for it=1:nt
    LY.(xX{:})((LY.nX(it)+1):end,it) = NaN;
  end
end

% Chuck extra X-points
nXmax = max(LY.nX);
for xX = {'rX','zX','FX'}
  LY.(xX{:})(nXmax+1:end,:) = [];
end

% Order X-points by proximity to FB
for it = 1:nt
  if LY.nA ~= 1, continue; end
  FX = LY.FX(:,it); FB = LY.FB(:,it);
  [~,k] = sort(abs(FX-FB));
  LY.rX(:,it) = LY.rX(k,it);
  LY.zX(:,it) = LY.zX(k,it);
  LY.FX(:,it) = FX(k);
end

%% DML synthetic measurement
LY.Xt = LY.Ft + L.Mty*reshape(LY.Iy,L.ny,nt);

%% Isconverged flag
LY.isconverged = ~LY.rst;

%% Add aq,rq,zq aW of correct size
if ~L.P.iterq
  LY.aq = zeros(0,0,L.nD,nt,'single');
  LY.rq = LY.aq; LY.zq = LY.aq; 
  LY.aW = zeros(0,0,nt,'single');
else
  % reshape contour points into 4D arrays
  LY.aq = reshape(LY.aq,L.noq,L.npq,L.nD,nt);
  LY.zq = reshape(LY.zq,L.noq,L.npq,L.nD,nt);
  LY.rq = reshape(LY.rq,L.noq,L.npq,L.nD,nt);
end