function [Raxc,Rauc,Razc,Ra0c,Rexc,Reuc,Rezc,Re0c,Rixc,Riuc,Rizc,Ri0c, ...
  IDs,ws,TusU,TdzsU,d1dt,d2dt] = liulsqinit(L,LXs)
% LIULSQINIT assembles all LIU optimization problem for given time interval
%
% [Raxc,Rauc,Razc,Ra0c,Rexc,Reuc,Rezc,Re0c,Rixc,Riuc,Rizc,Ri0c,ws,TusU,TzsU,d1dt,d2dt] ...
%   = liulsqinit(L,LXs)
% 
% Inputs: L,LXs: LIU L, and (possibly multi-slice) LX structures
% Outputs:
% * cell arrays Raxc,Rauc,Razc,Ra0c,Rexc,Reuc,Rezc,Re0c,Rixc,Riuc,Rizc,Ri0c
%   with optimization problem matrices for each time (c stands for cell,
%   see LIUOPT for details about the R?? notation)
% * ws: cell arrays of w (see LIUOPT for details)
% * TusU,TdzsU: Transfer matrices between us, dzs and U
% * d1dt,d2dt: Stencils for 1st and 2nd order time derivatives
%
% SEE ALSO MEQLSQPREP, MEQLSQSOLVE, LIUOPT, LIUT
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

% Setup terms for LIU optimization problem.
% Get fbtopt for multiple slices into cell arrays

nt  = numel(LXs.t);
nu  = L.nuN;
ndz = L.ndz;

% init

c = cell(1,nt);
Raxc=c;Rauc=c;Razc=c;Ra0c=c;
Rexc=c;Reuc=c;Rezc=c;Re0c=c;
Rixc=c;Riuc=c;Rizc=c;Ri0c=c;
IDs=c; ws=c;
c = cell(1,nt);
TusU=c;TdzsU=c;

nU = (nu+ndz)*nt;
eyeU = eye(nU);

% Stencils for 1st and 2nd order time derivatives (inactive)
d1dt = [];
d2dt = [];

for it = 1:nt
  LXt = meqxk(LXs,it);
  % Run liuopt for each slice
  [Raxc{it},Rauc{it},Razc{it},Ra0c{it},...
   Rexc{it},Reuc{it},Rezc{it},Re0c{it},...
   Rixc{it},Riuc{it},Rizc{it},Ri0c{it},...
   IDs{it},ws{it}] = liuopt(L,LXt);
  
  % Transfer matrix between us{it} and U
  TusU{it} = eyeU((it-1)*nu+1:nu*it,:);
  % Transfer matrix between dzs{it} and U
  TdzsU{it} = eyeU(nu*nt+(it-1)*ndz+(1:ndz),:);
end
