%LIUGRFX  RFX LIUQE geometry and electromagnetic parameters
% LIUGRFX(~,P) returns a structure with geometry for RFX. See also LIUG.
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
function G = liugrfx(~,P)
 
 A = load('LIUGRFX'); A = A.G;
 
 % Vessel
 G.rv = A.rv; G.zv = A.zv;
 G.Rv = A.Rv;
 
 Yvv = diag(1./G.Rv); % coil resistances in parallel
 Tsv = A.Tvs';
 G.Tvs = Yvv * Tsv' / (Tsv * Yvv * Tsv');
 G.Rs  = diag(G.Tvs' * diag(G.Rv) * G.Tvs);
 
 % Active coil turns
 G.rw  = A.rw; G.zw = A.zw;
 G.Twa = A.Twa;
 
 % Tile apperture (limiter)
 G.rl = A.rl; G.zl = A.zl;
 
 % Magnetics
 G.rm = A.rm; G.zm = A.zm; G.am = A.am;
 G.rf = A.rf; G.zf = A.zf;
 
 G = liug(P,G); % compute derived quantities
 
 return
