%LIUGANA  ANA LIUQE geometry and electromagnetic parameters
% LIUGANA(~,P) returns a structure with geometry for ANA. See also LIUG.
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
function G = liugana(~,P)

G = meqgana(P);

%% Plasma current estimator: Ip = Ipm*Bm + Ipa*Ia + Ipu*Iu
% Similar to TCV
[~,im] = sort(unwrap(atan2(G.zm,G.rm - P.r0)),'descend'); % Order them clockwise in (R,Z) 
G.Ipm = sqrt(diff(G.rm(im([end,1:end]))).^2 + diff(G.zm(im([end,1:end]))).^2).';
G.Ipm = -(G.Ipm+G.Ipm([2:end 1]))/(2*mu0); % Minus sign because probe orientation (G.am) is going counter-clockwise

return
