function [...
  Ief ,Iem ,Iea ,Ieu , Iep,...
  Ipf ,Ipm ,Ipa ,Ipu , Ipp,...
  zIpf,zIpm,zIpa,zIpu,zIpp,...
  rIpf,rIpm,rIpa,rIpu,rIpp] = lih2obs(L)
% LIH2OBS get linear observers using LIH matrices/methods
% These give results equivalent to running liht with iterh=0
% but in a single matrix multiplication.

%
% [ Ief, Iem, Iea, Ieu, Iep,...
%   Ipf, Ipm, Ipa, Ipu, Ipp,...
%  zIpf,zIpm,zIpa,zIpu,zIpp,...
%  rIpf,rIpm,rIpa,rIpu,rIpp] = lih2obs(L)
%
% Input: L structure from lih. 
%
% Returns observer matrices such that:
% Ie   = [Ief,Iem,Iea,Ieu,Iep] * Xd;
% IpD  = [Ipf,Ipm,Ipa,Ipu,Ipp] * Xd;
% zIp = [zIpf,zIpm,zIpa,zIpu,zIpp] * Xd;
% rIp = [rIpf,rIpm,rIpa,rIpu,rIpp] * Xd;
% where Xd are the (unweighted) measurements: [Ff;Bm;Ia;Iu;Ip]
%
% If ~L.P.Ipmeas, Ip is estimated from other measurements, and there is no direct Ip measurement contribution
% If ~L.P.ivesm, there are no vessel measurements and the *u terms are empty
%
% NB: lih/liu uses Xt*rBt as well in the measurements but this is always
% excluded, so we don't include it in these observers.
%
% If L.P.idoublet, Ip and zIp/rIp observer matrices will have two rows for
% top/bottom lobes (following L.mask_t,L.mask_b)
%
% See also LIHT, LIHLSQSOLVE
% 
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

%% Define observers from Jh (FE currents) to quantities of interest
mask_t = L.mask_t;
mask_b = L.mask_b;
if ~L.P.idoublet
  Iph  = L.Iph;
  Iprh = L.Iprh;
  Ipzh = L.Ipzh;
else % doublets
  % define top and bottom half observers
  Iph  = [L.Iph_t;L.Iph_b];
  Ipzh = [
    sum((L.zzy(:)).*mask_t.*L.Tyh,1);
    sum((L.zzy(:)).*mask_b.*L.Tyh,1)];
  Iprh = [
    sum((L.rry(:)).*mask_t.*L.Tyh,1);
    sum((L.rry(:)).*mask_b.*L.Tyh,1)];
end

[Med,Mhd,kdu,kdp] = lih2obs_setup(L);

% dispatch
Ief = Med(:,L.kdf);
Iem = Med(:,L.kdm);
Iea = Med(:,L.kda);
Ieu = Med(:,  kdu);
Iep = Med(:,  kdp);

Ipf  = Iph  * Mhd(:,L.kdf);
Ipm  = Iph  * Mhd(:,L.kdm);
Ipa  = Iph  * Mhd(:,L.kda);
Ipu  = Iph  * Mhd(:,  kdu);
Ipp  = Iph  * Mhd(:,  kdp);

zIpf = Ipzh * Mhd(:,L.kdf);
zIpm = Ipzh * Mhd(:,L.kdm);
zIpa = Ipzh * Mhd(:,L.kda);
zIpu = Ipzh * Mhd(:,  kdu);
zIpp = Ipzh * Mhd(:,  kdp);

rIpf = Iprh * Mhd(:,L.kdf);
rIpm = Iprh * Mhd(:,L.kdm);
rIpa = Iprh * Mhd(:,L.kda);
rIpu = Iprh * Mhd(:,  kdu);
rIpp = Iprh * Mhd(:,  kdp);


end
