/* [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved. */
# include "meq.h"

void FLT_NAME(nfdb)(FLT *dnf, FLT *f, int nx, int ny, int ntot)
{
  int i, k, nx2=nx-2, nx3=nx-3, nx5=nx-5, ny2=ny-2;
  FLT *f1, *f2;
  for (k = 0; k < ntot; k++) {
    f2 = (f1 = f+nx+1) + nx;
    for (i=nx2; i--;) {
      *dnf++ = *f1++ * FLTC(4.0) - *f2++;
    }
    f1 = f+nx+1; f2 = f1+1;
    for (i=ny2; i--; ) {
      *dnf++ = *f1 * FLTC(4.0) - *f2;
      f1 += nx3; f2 += nx5;
      *dnf++ = *f1 * FLTC(4.0) - *f2;
      f1 += 3; f2 += 5;
    }
    f2 = (f1 = f+ny2*nx+1) - nx;
    for (i=nx2; i--;) {
      *dnf++ = *f1++ * FLTC(4.0) - *f2++;
    }
    f += nx*ny;
  }
}
