/* [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved. */
# include "meq.h"

/* [Ie,aj,st] = ipmj(uAjj,Aje,Aej,Ie0,aj0,Ie_,aj_,Qcj,Xc,s,z,tol,iters) */
void FLT_NAME(ipmj)(FLT *Ie, FLT *aj, meq_bool *st, FLT *uAjj, FLT *Aje, FLT *Aej, FLT *Ie0, FLT *aj0, FLT *Ie_,
                    FLT *aj_, FLT *Qcj, FLT *Xc, FLT *s, FLT *z, FLT tol, int iters, FLT *w, int nj, int ne, int nc)
{
 FLT *aj1=w, *aj2=aj1+nj, *w1=aj2+nj; /* w size  nj*(nj+1)/2+4*nj+6*nc */
 FLT t,t0;
 int k,kit;
 int kt; /* dummy for kt return from ipm2 */

 /* Ie = Ie_; */
 COPY(ne,Ie,Ie_);
 /* aj1 = aj_; */
 COPY(nj,aj1,aj_);
 /* for kit=iters:-1:1 */
 for (kit=iters; kit--;) {
  /* aj2 = aj0 + Aje*Ie; */
  COPY(nj,aj2,aj0);
  GEMV(aj2,Aje,Ie,nj,ne);
  /* [aj,s,z,~,st] = ipm2mex(uAjj,aj2,Qcj,Xc,aj1,s,z,tol,iterj,false); */
  FLT_NAME(ipm2)(aj,s,z,&kt,st,uAjj,aj2,Qcj,Xc,aj1,s,z,tol*1e6,1,meq_false,w1,nj,nc);
  /* Ie = Ie0 + Aej*aj; */
  COPY(ne,Ie,Ie0);
  GEMV(Ie,Aej,aj,ne,nj);
  /* if norm(aj-aj1,Inf) < tol, break, end */
  t = FLTC(0.0);
  for (k=nj; k--;) {
   t0 = ABS(aj[k]-aj1[k]);
   if (t0 > t) t = t0;
  }
  *st = *st && (t < tol);
  if (*st) break;
  /* aj1 = aj; */
  COPY(nj,aj1,aj);
 }
}
