/* [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved. */
# include "meq.h"

/*  [VQ,AQ] = fsg2(aq,rA,crq,doq) */
void FLT_NAME(fsg2)(FLT *VQ, FLT *AQ, FLT *aq, FLT rA,
                    FLT *crq, FLT doq, int npq, int noq) {
 int i, j;
 FLT *pVQ = VQ, *pAQ = AQ, *paq = aq, *pcrq;
 FLT vaq,qaq;
 FLT s1, s2, s3;
 FLT C1 = 0.5*doq, C2 = TWOPI*doq;
 /* axis */
 *pVQ++  = FLTC(0.0);
 *pAQ++  = FLTC(0.0);

 for (j = npq; j--; ) {
  pcrq = crq;

  /* theta integrals */
  s1 = s2 = s3 = 0.0;
  for (i = noq; i--; ) {
   vaq = (*paq++);
   qaq = vaq*vaq;
   s1 += qaq * (0.5*rA + ITHREE * vaq * (*pcrq++));
   s2 += qaq;
  }

  *pVQ++  = C2 * s1;
  *pAQ++  = C1 * s2;
 }
}
