function opts = ipmopts(varargin)
% IPMOPTS Provides parameters for ipmwrapper routine
%
%   OPTS = IPMOPTS(VARARGIN)
%
% Available parameters:
%   useoptimized
%   niter
%   tol
%   debug
%   presolve
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

% Defaults
opts.useoptimized = true;
opts.niter = 200;
opts.tol = 1e-12;
opts.debug = false;
opts.presolve = false;

if nargin < 1
  return
end

% Parse optional inputs
p = inputParser;
p.addParameter('useoptimized',opts.useoptimized,@(x) isscalar(x) && islogical(x));
p.addParameter('niter'       ,opts.niter       ,@(x) isscalar(x) && isnumeric(x) && (x == round(x)));
p.addParameter('tol'         ,opts.tol         ,@(x) isscalar(x) && isnumeric(x) && (x > 0));
p.addParameter('debug'       ,opts.debug       ,@(x) isscalar(x) && islogical(x));
p.addParameter('presolve'    ,opts.presolve    ,@(x) isscalar(x) && islogical(x));
p.parse(varargin{:});
opts = p.Results;

end
