%IPM4MEX  Interior point method for aX>0 and no equality constraints 
% [X,Z,KT,ST] = IPM4MEX(UH,C,A,XI,ZI,TOL,NIT,VERB) finds X that minimises
% X'*H*X/2+C'*X, A*X>0 with scalar A, UH=H(TRIU(TRUE(SIZE(H)))), using the
% interior point method. XI,ZI are initial guesses. NIT and TOL control the
% iteration numbers and the convergence criterion. If VERB=TRUE progress
% is displayed. STAT=1 if success. KT is the number of iterations performed.
%
% For details, see: [MEQ-redbook] 
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
function [varargout] = ipm4mex(varargin)
 warning('MEQ:MEX "%s" not compiled or not in the Matlab path',mfilename)
 
 [varargout{1:nargout}] = ipm4mexm(varargin{:});
end
