function T = toepconv(A,N)

% TOEPCONV  polynomial multiplication by matrix multiplication
% 	TOEPCONV[A,N] creates the Toeplitz matrix that allow to multiply any
%	polynomial of degree N by the polynomial A by postmultiplication of 
%	the former by this matrix. Result size : N+1 x length(A)+N
%
%
% [+GenLib General Purpose Library+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

if N < 0
 T = [];
else
 T = toeplitz([A(1);zeros(N,1)],[A zeros(1,N)]);
end
