% Test collection for Octave
%
%   Only basic tests to ensure that no MATLAB-specific feature is used
%
% [+GenLib General Purpose Library+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

% Define missing functionality
%!function out=maxNumCompThreads(in)
%!  out=1;
%!endfunction

% Check paths assuming this is run from the toolbox base directory
%!shared tbxpath
%! tbxpath=pwd;
%!test
%! assert(which('bspsum'), fullfile(tbxpath,['bspsum.',mexext]))

% Test for bspbase
%!test
%! n = 101;
%! order = 4;
%! nsp = 15;
%! knots = linspace(0,1,nsp+order);
%! X = linspace(knots(order),knots(end-order+1),n);
%! y = bspbase(knots,order,X);
%! assert(size(y), [nsp,n]);
%! assert(~any(isnan(y(:))));
%! assert(sum(y,1), ones(1,n), 10*eps);

% Test for bspsum
%!test
%! n = 101;
%! nsp = 15;
%! order = 4;
%! nkts = nsp-order+1;
%! knots = (1:nsp)-(order-1);
%! y = bspsum(knots,eye(nkts,nsp),linspace(0,10,n),0,0);
%! assert(size(y), [n,nsp]);
%! assert(sum(y,2), ones(n,1), 10*eps);
%! assert(~any(isnan(y(:))));

% Test for csdec
%!test
%! T = linspace(0,1,21);
%! x = linspace(0,1,21);
%! ec = {'a','n','p','s','t','u','v','w'};
%! for ii=1:numel(ec)
%!   [M,tau] = csdec(T,x,ec{ii});
%! end

% Test for bsp2deval
%!test
%! % 1. Define analytical function
%! fh = @(x,y)    x.^3 - 3.*x.^2.*y +  6.*x.*y.^3 -    y.^3;
%! % 2. Construct 2D spline interpolant
%! x = linspace(0,1,11).';
%! y = linspace(0,1,21).';
%! [Mx,taux] = csdec(x,x,'a');
%! [My,tauy] = csdec(y,y,'a');
%! [yy,xx] = meshgrid(y,x);
%! % Spline coefficients
%! F = fh(xx,yy);
%! c = Mx*F*My.';
%! % 3. Evaluation on random values
%! n0 = 1001;
%! x0 = rand(n0,1);
%! y0 = rand(n0,1);
%! [f,dxf,dyf,dx2f,dxyf,dy2f] = bsp2deval(taux,tauy,c,x0,y0,[0,1,2],1);

% Test for greenem
%!test
%! r1 = 1+0.1*(0:2);
%! z1 = 0+0.0*(0:2);
%! r2 = 1+0.0*(0:1);
%! z2 = 1+0.1*(0:1);
%! [M1,BR1,BZ1] = greenem({'m','br','bz'},r1,z1,r2,z2);
%! M2  = greenem('m',r1,z1,r2,z2);
%! BR2 = greenem('br',r1,z1,r2,z2);
%! BZ2 = greenem('bz',r1,z1,r2,z2);
%! assert([M1;BR1;BZ1], [M2;BR2;BZ2]);
