function varargout = structcmp(S1,S2,varargin)
% [are_equal,errorstr] = structcmp(S1,S2,tol)
% Checks whether structures are equal.
% See HELP OBJCMP for details
%
% [+GenLib General Purpose Library+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

assert(isstruct(S1) && isstruct(S2),...
  'GENLIB:STRUCTCMP:NOTSTRUCTURES',...
  'both inputs must be structures, otherwise consider using objcmp()');

[varargout{1:nargout}] = objcmp(S1,S2,varargin{:});

end
