/* [+GenLib General Purpose Library+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved. */
/*
ifloor

returns the indices of the elements in a look-up table which are nearest but
smaller than the given values.

void ifloor(k,T,sizeT,X,sizeX)

int     *k;     indices of the nearest but smaller elements
                in table T for each value of X, -1 for X < T[0]
double  *T;     table to look up, must be sorted
int     sizeT;
double  *X;     values to look up, must be sorted
int     sizeX;
*/

void ifloor(int *k, double *T, int sizeT, double *X, int sizeX)
{
  register int i = sizeX-1, j = sizeT-1;

  /* Algorithm is identical to iceil applied in reverse order */
  while (i>=0) {
    if (j<0)
      k[i--] = -1; /* Values below T[0] */
    else if (X[i] >= T[j])
      k[i--] = j;
    else if (j >= 0)
      j--;
  }
}
