function root = ppzero(pp,z,d,tol)

% PPZERO	Piecewise polynomial (pp-form) zeros 
%   PPZERO(PP) returns the real zeros of the piecewise polynomial PP.
%   PPZERO(PP,Z) returns the zeros of PP - Z. PPZERO(PP,Z,D) returns the zeros
%   of the D-th value of PP - Z. A fourth argument specifies the tolerance to
%   reject complex roots. 
%
% [+GenLib General Purpose Library+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

% default arguments
if nargin < 2, z = 0; end
if nargin < 3, d = 1; end
if nargin < 4, tol = 0; end

[b,c,nb,nc,nd] = ppbrk(pp);
c = c((0:nb-1)*nd+d,:);	% select value
c(:,nc) = c(:,nc) - z;	% translate to 0
root = [];
for k = 1:nb
 r = roots(c(k,:));
 root = [root; real(r(r >= 0 & r < (b(k+1)-b(k)) & abs(imag(r)) <= tol))+b(k)];
end
