% PLOT_PERF_REPORTS run performance reports for greenem/bspsum and plot summary
%
% [+GenLib General Purpose Library+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

%% GREENEMMEX

res = runperf('greenem_perf.m');

resTable = res.sampleSummary;

A = sscanf([res.Name],'greenem_perf[nloops=P_%d]/perf_greenem(npar=P_%d)');

nloops = A(1:2:end);
npar   = A(2:2:end);

nnloops = numel(unique(nloops));
nnpar   = numel(unique(npar));

mask = npar>nloops;
x = nloops./npar;
y = resTable.Mean;

figure;
hold all;
plot(reshape(x,[nnpar,nnloops]),reshape(y,[nnpar,nnloops]),'-x');
plot(x(mask),y(mask),'or')
plot([min(x),max(x)],y(end-nnpar+1)./x(end-nnpar+1)*[min(x),max(x)],'YLimInclude','off','Color','k')
title('greenem')
set(gca,'xscale','log');xlabel('nloops/npar');
set(gca,'yscale','log');ylabel('Wall time');

%% BSPSUM

res = runperf('bspsum_perf.m');

resTable = res.sampleSummary;

A = sscanf([res.Name],'bspsum_perf[nsplines=P_%d,nx=P_%d]/perf_bspsum(npar=P_%d)');

nsplines = A(1:3:end);
nx       = A(2:3:end);
npar     = A(3:3:end);

nnsplines = numel(unique(nsplines));
nnx       = numel(unique(nx));
nnpar     = numel(unique(npar));

mask = npar>nsplines;
x = nsplines.*nx./npar;
y = resTable.Mean;

figure;
hold all;
plot(reshape(x,[nnpar,nnsplines*nnx]),reshape(y,[nnpar,nnsplines*nnx]),'-x');
plot(x(mask),y(mask),'or')
plot([min(x),max(x)],y(end-nnpar+1)./x(end-nnpar+1)*[min(x),max(x)],'YLimInclude','off','Color','k')
title('bspsum');
set(gca,'xscale','log');xlabel('nfunevals/npar');
set(gca,'yscale','log');ylabel('Wall time');
