classdef greenem_perf < matlab.perftest.TestCase
  % Test performance of greenem with different number of threads
  %
  % [+GenLib General Purpose Library+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

  properties
    data
  end

  properties (ClassSetupParameter)
    % Number of pairs of loops for which to compute the mutual inductance
    nloops = parameter_struct(10.^(1:6))
  end

  properties (TestParameter)
    % Number of openMP threads
    npar = parameter_struct(2.^(0:ceil(log2(maxNumCompThreads))));
  end

  methods(TestClassSetup)
    function greenemSetup(testCase,nloops)
      r1 = 1; % R position of reference loop
      z1 = 0; % Z position of reference loop

      r2 = 1+0.5*rand(nloops,1); % R 
      z2 =       rand(nloops,1); % Z
  
      testCase.data = {r1,z1,r2,z2};
    end
  end

  methods (Test,TestTags={'Unit'})
    function perf_greenem(testCase,npar)
      % Measure performance time for greenemmex

      [r1,z1,r2,z2] = deal(testCase.data{:});

      while testCase.keepMeasuring
        greenemmex(r1,z1,r2,z2,int32(0),npar);
      end

    end
  end
end
