classdef bspsum_perf < matlab.perftest.TestCase
  % Test performance of bspsum with different number of threads
  %
  % [+GenLib General Purpose Library+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

  properties
    data
  end

  properties (ClassSetupParameter)
    % Number of functions to evaluate
    nsplines = parameter_struct(2.^(0:6))
    % Number of points on which to evaluate each function
    nx = parameter_struct(10.^(2:2:4))
  end

  properties (TestParameter)
    % Number of openMP threads
    npar = parameter_struct(2.^(0:ceil(log2(maxNumCompThreads))));
  end

  methods(TestClassSetup)
    function bspsumSetup(testCase,nx,nsplines)
      % Cubic splines on [0,1] using 201 knots
      tau=(-3:203)/200;     % knots position
      k=4;                  % order
      x=linspace(0,1,nx+1); % positions where to evaluate each functions
      nc=numel(tau)-k;      % number of independent parameters per function
      mc=nsplines;          % number of functions
      c=rand(nc,mc);        % spline coefficients for each function
  
      testCase.data = {tau,c,x};
    end
  end

  methods (Test,TestTags={'Unit'})
    function perf_bspsum(testCase,npar)
      % Measure performance time for bspsum

      [tau,c,x] = deal(testCase.data{:});

      while testCase.keepMeasuring
        bspsum(tau,c,x,0,0,npar);
      end

    end
  end
end