/* [+GenLib General Purpose Library+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved. */
# include "genlib.h"

void mexFunction(int nlhs,       mxArray *plhs[],
                 int nrhs, const mxArray *prhs[])
{

# define MEXNAME iflooriceiliroundmex

 /* k = iflooriceiliroundmex(t,x,w); */

# define K  pout[0]

# define T  prhs[0] /* double, non-empty */
# define X  prhs[1] /* double */
# define W  prhs[2] /* int32, scalar */

 CHECK_NARGIN_EQ(3);

 CHECK_DOUBLE(T);
 if (mxIsEmpty(T)) mexErrMsgIdAndTxt("iflooriceiliroundmex:emptyT","ifloor/iround cannot work with an empty table T");
 CHECK_DOUBLE(X);
 CHECK_INT32(W);
 CHECK_SCALAR(W);

 CHECK_NARGOUT_LE(1);

 mxArray *pout[1] = {NULL};

 double *kp;
 int *k,sizeX,sizeT;
 register int i;
 
 /* sizes */
 sizeT = mxGetNumberOfElements(T);
 sizeX = mxGetNumberOfElements(X);

 /* memory allocation */
 K = mxCreateDoubleMatrix(mxGetM(X), mxGetN(X), mxREAL);
 k = (int *) mxCalloc(sizeX, sizeof *k);

 /* do the work */
 switch(*(int*)mxGetData(W)){
   case 0 :
     iround(k,mxGetPr(T),sizeT,mxGetPr(X),sizeX); break;
   case 1 :
     ifloor(k,mxGetPr(T),sizeT,mxGetPr(X),sizeX); break;
   case 2 :
     iceil(k,mxGetPr(T),sizeT,mxGetPr(X),sizeX); break;
 } 

 /* convert result in double and index starting at 1 */
 kp = mxGetPr(K);
 for (i = 0; i < sizeX; i++)
   *kp++ = (double)(k[i] + 1);
 mxFree(k);

 ASSIGN_PLHS;
}
