classdef mexargs < handle
  
 properties (SetAccess = public)
   mexname
   nargin
   nargout
   arg
 end

 methods
   function S = mexargs(mexname,nargin,nargout)
     S.mexname = mexname;
     S.nargin.check = nargin;
     S.nargout.check = nargout;
     S.arg = struct('default',{},'check',{});
   end

   function S = addarg(S,default,check)
     narg = numel(S.arg);
     S.arg(narg+1).default = default;
     S.arg(narg+1).check = check;
   end
 end
end