function k = ifloor(t,x,sortflag)

% IFLOOR	Index of the nearest but smaller
%   IFLOOR(T,X) returns the index of the nearest but smaller element in the
%   monotonic increasing table T for each value of X. Call IFLOOR with a 3rd
%   argument if X is non monotonic.
%
% [+GenLib General Purpose Library+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

if nargin < 3
 sortflag = 0;
end
if sortflag
 [x,ksort] = sort(x);
end
k = iflooriceiliroundmex(t,x,int32(1));
if sortflag
 k(ksort) = k;
end
