tau=(-3:203)/200;k=4;nx=1e6+1;x=linspace(0,1,nx);nc=numel(tau)-k;mc=9;c=rand(nc,mc);npar=1;

mexargs = {'mexc/bspsummex.c','src/bspsum.c','-Iinclude'};
mexargs4 = [mexargs,{'-DBSPSUM4'}];
mexargs4par = [mexargs4,{'-DBSPPAR'}];
mexargs4pargcc = [mexargs4par,{'CC=gcc','-lgomp','CFLAGS=$CFLAGS -fopenmp'}];
mexargs4paricc = [mexargs4par,{'CC=icc','CFLAGS=$CFLAGS -qopenmp','LDFLAGS=$LDFLAGS -qopenmp'}];

args = [struct('name','standard' ,'args',{mexargs}),...
        struct('name','bspsum4'  ,'args',{mexargs4}),...
        struct('name','openMPgcc','args',{mexargs4pargcc})];

if ~ispc
  args(4) = struct('name','openMPicc','args',{mexargs4paricc});
end

fig = figure;
ax1 = subplot(3,1,1,'Parent',fig);hold(ax1,'on');
ax2 = subplot(3,1,2,'Parent',fig);hold(ax2,'on');
ax3 = subplot(3,1,3,'Parent',fig);hold(ax3,'on');
for jj = 1:numel(args)
  clear('bspsummex');clear('bspsum');
  mex(args(jj).args{:});
  if ispc, delete('bspsum.mexw64');copyfile('bspsummex.mexw64','bspsum.mexw64'); end
  bspsum(tau,c,x,0,0,1);
  npar_ = 2.^(0:6); dtwall = npar_.*0; dtcpu = npar_.*0;  
  for ii = 1:numel(npar_)
    npar = npar_(ii);
    t=tic;cpu=cputime;
    bspsum(tau,c,x,0,0,npar);
    dtwall(ii) = toc(t);
    dtcpu(ii) = cputime-cpu;
  end
  plot(ax1,npar_,dtwall,'DisplayName',['WALL ',args(jj).name]);
  plot(ax2,npar_,dtcpu ,'DisplayName',['CPU  ',args(jj).name]);
  plot(ax3,npar_,dtcpu./dtwall,'DisplayName',['NCPU  ',args(jj).name]);
end
set(legend(ax1),'Interpreter','none');
set(legend(ax2),'Interpreter','none');
set(legend(ax3),'Interpreter','none');