function [f,gr,gz,hrr,hrz,hzz,d3rrr,d3rrz,d3rzz,d3zzz] = bsp2deval(rk,zk,c,r,z,d,npar)
% BSP2DEVAL evaluate 2D B-splines and their derivatives
%
% [+GenLib General Purpose Library+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

hasd0 = any(d==0);
hasd1 = any(d>0);
hasd2 = any(d>1);
hasd3 = any(d>2);

f = [];
gr = [];
gz = [];
hrr = [];
hrz = [];
hzz = [];

sz = size(r);
r = r(:);
z = z(:);

cr0 = bspsum(rk,c,r,0,0,npar).';
if hasd1
  cr1 = bspsum(rk,c,r,1,0,npar).';
  if hasd2
    cr2 = bspsum(rk,c,r,2,0,npar).';
    hrr = reshape(bspsum(zk,cr2,z,0,1,npar),sz);
    hrz = reshape(bspsum(zk,cr1,z,1,1,npar),sz);
    hzz = reshape(bspsum(zk,cr0,z,2,1,npar),sz);
    if hasd3
      cr3 = bspsum(rk,c,r,3,0,npar).';
      d3rrr = reshape(bspsum(zk,cr3,z,0,1,npar),sz);
      d3rrz = reshape(bspsum(zk,cr2,z,1,1,npar),sz);
      d3rzz = reshape(bspsum(zk,cr1,z,2,1,npar),sz);
      d3zzz = reshape(bspsum(zk,cr0,z,3,1,npar),sz);
    end
  end
  gr  = reshape(bspsum(zk,cr1,z,0,1,npar),sz);
  gz  = reshape(bspsum(zk,cr0,z,1,1,npar),sz);
end
if hasd0
  f = reshape(bspsum(zk,cr0,z,0,1,npar),sz);
end
end
