function Sjoin = appendstruct(S1,S2)
% Sjoin = appendstruct(S1,S2)
% Joins to structures by appending the fields of S2 to S1
%
% [+GenLib General Purpose Library+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

assert(isstruct(S1)&&isstruct(S2),'both inputs must be structures')

Sjoin = S1;
myfieldnames=fieldnames(S2);
for ifield=1:numel(myfieldnames)
    myfieldname = myfieldnames{ifield};
    if isfield(S1,myfieldname)
        warning('field %s already exists in first structure, will be overwritten!',myfieldname);
    end
    Sjoin.(myfieldname) = S2.(myfieldname);
end
end