% General Purpose Library
% Version 3.9.1 26-Sep-2024
%
% B-splines
%   bspbase              - B-spline base functions
%   bspsum               - B-spline base function combination
%   bsp2deval            - evaluate 2D B-splines and their derivatives
%   cs2deval             - Regular cubic B-spline function evaluation
%   csdec                - Cubic B-spline decomposition
%   pp2bsp               - converts function in pp-form to genlib b-spline format
%
% Green functions in toroidal geometry
%   greenem              - Electromagnetic Green's functions
%   green3d              - Mutual inductance of 3D loops
%   ellipfast            - Fast computation of the complete elliptic integral
%
% Other electromagnetic functions
%   vveig                - Vessel eigenmode representation
%
% Search values in arrays
%   iceil                - Index of the nearest but larger
%   ifloor               - Index of the nearest but smaller
%   imax                 - Index of maximum
%   imin                 - Index of minimum
%   iround               - Index of the nearest element
%   minloc               - Minimum location
% 
% Generic object comparison
%   objcmp               - Compares 2 generic MATLAB objects
%
% Structure manipulation
%   appendstruct         - Sjoin = appendstruct(S1,S2)
%   struct2single        - convert all doubles in a structure to singles, 
%   struct2str           - generate cell array of strings that define structure.
%   structcmp            - Compares 2 structures
%   writestruct_to_mfile - writes a structure to a .m file.
%
% Cell array manipulation
%   cell2str             - function str = cell2str(C,n)
%   writecell            - writes a cell to a .m file.
%
% Miscellaneous
%   bytesof              - BYTESOF(A) returns a UINT8 array with the bytes of A.
%   check_headers        - Checks whether desired copyright headers are in place
%   check_matlab_syntax  - pass = check_matlab_syntax(myfolder,varargin)
%   cpaircov             - Covariance matrix of complex numbers
%   csder                - values = csder(x,y,yp[,xx])
%   csmod                - values = csmod(x,y[,ec][,xx])
%   ifc                  - IFC(C,A,B) returns A if the scalar logical C is TRUE, B otherwise.
%   isnans               - ISNAN   True for Signaling Not a Number
%   isodd                - Test for odd numbers
%   isort                - Sort index
%   loadxdr              - Load an XDR data file
%   mat2xdr              - Conversion from MAT file to XDR file
%   mknw                 - Build an electrical network representation
%   nans                 - Signaling Not a Number
%   nedit                - 
%   osc                  - Modulation analysis
%   pathck               - check path for redundant m-files
%   polygc               - contours contained in polygon
%   polygx               - XPOLYG   polyline polygon intersection
%   pprace               - Piecewise polynomial descrption of a racetrack
%   ppzero               - Piecewise polynomial (pp-form) zeros 
%   printmenu            - CRPP print menu
%   resamp               - Time signal resampling
%   rpdcov               - Rational fraction to residue-pole covariance transformation
%   rpdjacobian          - Rational fraction to residue-pole-rest Jacobian
%   savexdr              - Save data in an XDR file
%   sep2mat              - Single separated string to string matrix
%   sti                  - Frequency domain transfer function reduction
%   stidemo              - stidemo
%   stitest              - stitest
%   toepconv             - polynomial multiplication by matrix multiplication
%   weeknum              - Week number of a date
%   writegif             - writegif.m
%   xdr2mat              - Conversion from XDR file to MAT file
%   xmtimes              - XMTIMES(X,Y) computes inner product of x*y using fast libraries.
%   ztrig                - Schmitt-trigger
%
% Test suite
%   run_genlib_tests     - Template test runner for toolbox tests
%   tests_matlab         - Auxiliary file used to run genlib test suite from the shell
%   tests_octave         - Auxiliary file used to run genlib test suite for Octave from the shell
%   test_matlab_syntax   - Class to test matlab syntax issues in the present directory
%
% [+GenLib General Purpose Library+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
