%FSGIMEX  Flux surface geometrical integrals
% [Q0,Q1,Q2,Q3,Q4,IQ,IT,RB,LP,Q5,SL] =
% FSGI(A1,A2,R,IR,RA,FA,FB,D2FA,LX,RX,IT,IDTH) computes
%
% Geometrical integrals --------- S() th integral ----------- axis ---- X
% Q0 <1/R>                          S(A1)/S(A1*R)             1/RA   1/RX
% Q1 -dpsi/dV                    2/pi*FAB/S(A1*R)   1/4/pi^2*BA/RA      0
% Q2 <1/R^2>                      S(A1/R)/S(A1*R)           1/RA^2 1/RX^2
% Q3 <|grad psi|^2/R^2>  16*FAB^2*S(A2/R)/S(A1*R)                0      0
% Q4 <|grad psi|^2>      16*FAB^2*S(A2*R)/S(A1*R)                0      0
% IQ 1/q                         4*FAB*IT/S(A1/R) 1/2/pi*ITA*BA*RA      0
% IT Ip(rho)              -2/pi*|FAB|/mu0*S(A2/R)                0      -
% RB int(rdlp)/int(dlp)           S(A3*R)/S(A3  )               RA      -
% LP int(dlp)                             S(A3  )                0      -
% Q5 <|grad psi|/2/pi> 2/pi*|FAB|*S(A3*R)/S(A1*R)                0      0
% SL 2 pi int(rdlp)                  2*pi*S(A3*R)                0      -
%
% A1=da^2/drh/rh, A2=((da^2/dth/2)^2/a^2+a^2)/(da^2/drh/rh), A3=sqrt(A1*A2)
% with a(rh,th) the distance from the magnetic axis to the flux surface
% with normalised coordinate rh~=0 at poloidal angle th. R=RA-a*cos(th),
% IR=1/R. RA,FA position and flux of magnetic axis. FB flux on LCFS.
% D2FA=sign(Ip)*sqrt(d2FA/dr2*d2FA/dz2-d2FA/drdz.^2). LX true if X point.
% RX position of X point. IT=1/T(rh) with T(rh)=rBt (vaccum+plasma). IDTH
% inverse of theta grid spacing.
%
% A1 is linked to the jacobian J of the (psi,theta,phi) coordinate system:
%   J = R*a*da/dpsi = -A1*R/4/FAB
% A2/A1 is linked to the length of the grad(psi) vector squared:
%   |grad psi|^2 = 16 FAB^2 A2/A1
% A3 is linked to the dlp element:
%   dlp = A3 dth or A3 = dlp/dth
%
% In the table above the last column "X" indicates the value at the LCFS
% when the plasma has an X-point. "-" indicates that the integral is not
% singular and the standard computation can be used.
%
% For details, see: [MEQ-redbook] 
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
function [Q0Q,Q1Q,Q2Q,Q3Q,Q4Q,iqQ,ItQ,LpQ,rbQ,Q5Q,SlQ] = fsgimex(a1q,a2q,rq,irq,rA,FA,FB,BA,lX,rX,iTQ,idoq)
 warning('MEQ:MEX "%s" not compiled or not in the Matlab path',mfilename)
 
 [Q0Q,Q1Q,Q2Q,Q3Q,Q4Q,iqQ,ItQ,LpQ,rbQ,Q5Q,SlQ] = fsgimexm(a1q,a2q,rq,irq,rA,FA,FB,BA,lX,rX,iTQ,idoq);
 
end
