%FSG2MEX  Flux surface geometrical integrals continued
%   [VQ,AQ] = FSG2(aq,RA,CRQ,DOQ)
%
% Computes the flux-surface volume VQ and cross-section area AQ based on
% the contour minor radius aQ(rh,th), magnetic axis major radius RA.
% CRQ=-cos(OQ) such that RQ = RA+CRQ*aQ and DOQ is the grid spacing for
% the poloidal angle.
%
% The formulas are:
%  - VQ  = int(RQ*aQ*daQdrh drh.dth.dphi) = 2*pi int((RA/3 - aQ*cos(th)/2)*aQ^2 dth)
%  - AQ  = int(   aQ*daQdrh drh.dth     ) =      int(                 1/2 *aQ^2 dth)
%
% For details, see: [MEQ-redbook] 
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
function [VQ,AQ] = fsg2mex(aq,rA,crq,doq)
  warning('MEQ:MEX "%s" not compiled or not in the Matlab path',mfilename)

  [VQ,AQ] = fsg2mexm(aq,rA,crq,doq);

end
