%FL4PMEX  Four point interpolation for the flux on the limiter
% [FL,DRFL,DZFL] = FL4PMEX(FX,KL,CL,FN) computes with a four point
% interpolation the flux on the limiter. KL is the 0-based index of the
% reference grid point (R,Z), and the coefficients to be used at the four
% points:
%   FL = C(1,:)*FX(R,Z)+C(2,:)*(R+DR,Z)+C(3,:)*(R+DR,Z+DZ)+C(4,:)*(R,Z+DZ)
% All points but the extrema compatible with the sign of FN are tagged
% with FN. The gradients in the R and Z direction are also computed to
% later dismiss points with a positive gradient in the direction away
% from the plasma axis corresponding to the private flux region.
%
% For details, see: [J-M.Moret et al. Fus.Eng.Des 2015], Section 4.3
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
function [Fl,drFl,dzFl] = fl4pmex(Fx,kl,cl,FN)
 warning('MEQ:MEX "%s" not compiled or not in the Matlab path',mfilename)
 
 [Fl,drFl,dzFl] = fl4pmexm(Fx,kl,cl,FN);
 
end
