function LX = fgsxana(t,L)
% FGSXANA - Data loading for FGS anamak
% LX = fgsxana(t,L)
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

fields_to_rm = {'iterq','algoNL','fastcoil','Ipmin','cde','argout',...
  'jacobian_handle','jacobian_sparse','algoGMRES','userowmask',...
  'mkryl','usepreconditioner'};
P = rmfield(L.P,fields_to_rm(isfield(L.P,fields_to_rm)));
PP = [fieldnames(P),struct2cell(P)]';          % pass L parameters as fbt inputs
[Lfbt,~,LXfbt] = fbt('ana',L.P.shot,t,PP{:});  % equilibria from FBT
assert(~isempty(LXfbt) && all(LXfbt.isconverged),'FBT did not converge')
% Convert to target L structure format
LX = meqxconvert(Lfbt,LXfbt,L);
end
