function G = fgsgtcv(shot, P)
%FGSGTCV  TCV Forward-LIUQE geometry and electromagnetic parameters
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

switch P.selu
  case {'v','e'}
    xargs = {'Muu','Mxu'}; % request optional extra outputs
  case {'s'}
    xargs = {'Mxs'};
  otherwise
    xargs = {};
end

P.shot = shot;
sels = []; sell = []; self = []; selm = [];
G = meqgtcv(P,P.sela,sels,sell,self,selm,P.selx,P.selu,P.selc,xargs{:});
end
