function L = fgsc(P,G,isEvolutive)
% FGSC Parameter consolidation for fgs
% L = fgsc(P,G,isEvolutive)
% If isEvolutive=true, fgsc is called from FGE
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

L = meqc(P,G);

%% if isEvolutive is not given, a static equilibrium computation is assumed
if nargin <= 2, isEvolutive = false; end

%% Code name
L.code = 'fgs';

%% Constraint functions
L.agconc = meqagconc(P.agcon,L.TDg,P.idoublet); % consolidate constraint equations
L.nC     = size(L.agconc,1);                    % number of constraint equations

%% CDE functions (only static CDEs allowed in fgs)
[L.cdec, L.icde, L.np] = meqcdec(P.cde,L.agconc,L.fTg,L.TDg,L.nD,isEvolutive);
assert(L.nC + L.np == L.ng,...
  'Number of ag constraints (%d) and CDE residuals (%d) must match number of basis functions (%d)',...
  L.nC,L.np,L.ng)

%% NL model setup
[L.ind,L.nN,L.dimN,L.xscal,L.resscal,L.LX2x,L.isEvolutive,L.nuN,L.nrD] = meqalgoNLc(L,P.algoNL,false);

%% Additional derivative functions
if P.anajac
  % Jacobians of meqFx
  if P.gsxe~=3, [L.Mxy,L.Mxe] = meqFxjac(L); end
  
  % Linear part of jacobians
  [L.Jx,L.Ju,L.Jxdot] = fgeFvacJac(L);
end

end
