function P = fgeptcv(shot,varargin)
% defines fge parameters
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
P = meqptcv(shot);
for k = 1:2:length(varargin), P.(varargin{k}) = varargin{k+1}; end

%% defaults for fgeptcv
D.insrc = 'liu'; % Source for LX data: 'fbt' (FBTE nodes) 'liu' (LIUQE.M nodes)
D.selu = 'v';
D.izgrid = true;
D.eqfct = @meqetcv;

D.isrzp = false; %load parameters specific for rzip model

% substitute defaults where necessary
for k = fieldnames(D)'
  if ~isfield(P,k{1}), P.(k{1}) = D.(k{1}); end
end

P.shot = shot;
end
