function [Prec,Jx] = fgepre(L,LX,P,dt)
% Computes preconditioner for FGE using lin terms
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

if strcmp(P.prectype,'user')
  Jx = []; % Jx not needed
else
  if L.isEvolutive && dt
    % fgeFlin calls fgeF with LXt=LX, LYp=LX so that Jx is computed with dt=0
    [~,Jx,~,Jxdot] = fgeFlin(L,LX);
    Jx(L.ind.irD,:) = Jx(L.ind.irD,:) + 1/dt*Jxdot;
  else
    [~,Jx] = fgeFlin(L,LX);
  end
end

Prec = preconditioner_init(P,Jx,L.nN);

end
