function [Ei,Vi,LYi] = fgeploteig(L,varargin)
% FGEPLOTEIG Plots unstable eigenmodes from fgeeig
% [Ei,Vi,LYi] = fgeploteig(L,varargin)
%
% Calls fgeeig, see FGEEIG for details
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

[Ei,Vi,LYi] = fgeeig(L,varargin{:});
nmodes = numel(Ei);

for jj=1:nmodes
  if nmodes>1
    subplot(1,nmodes,jj);
  end
  
  cla;
  imagesc(L.ry,L.zy,LYi(jj).Iy,'AlphaData',abs(LYi(jj).Iy)>eps); hold on;  axis tight;  
  
  if L.P.izgrid
    meqplotfancy(L,LYi(jj),'FxLevels',16,'vacuum',true);
  else
    contour(L.rx,L.zx,LYi(jj).Fx,21,'linecolor',0.5*[1 1 1]);
  end
  set(gca,'clim',[min(LYi(jj).Iy(:)) max(LYi(jj).Iy(:))]);
  
  axis(gca,'equal','xy');
  if Ei(jj)>0
    title(sprintf('unstable mode, \\gamma=%2.2f',Ei(jj)))
  else
    title(sprintf('  stable mode, \\gamma=%2.2f',Ei(jj)))
  end
end
