function [LX] = fgeinit(L,LX)
% function [LX] = fgeinit(L,LX)
% Compute statonary-state initial condition for FGE, and LX.Va 
% (possibly time-varying, when solving CDE) to sustain the initial 
% equilibrium.
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

%% Find Ia, Iv, Va consistent with initial equilibrium.
LX = meqinit(L,LX);

%% Compute FGS solution to have a converged starting equilibrium
if L.P.debug, fprintf('\nCompute FGE initial condition using FGS\n'); end
Ls = L;
if ~isempty(L.P.cde)
  if endsWith(L.P.cde, '0D')
    Ls.P.cde = []; % no CDE for initial condition
    Ls.P = replace_cde_constraint(L, Ls.P);
  else
    if ~contains(L.P.cde, 'static') % if it is a non-static CDE, use Iy init
      Ls.P.cde = 'static_Iy_1D';
    elseif strcmp(L.P.cde, 'static_cde_1D')
      warning('Trying to fit steady state TT'' profiles. Might not converge if input profiles are too far off.')
    end
  end
end
Ls = fgsc(Ls.P,Ls.G);  % re-consolidate for FGS
LY = fgst(Ls,LX,...
  'kmax',200,'debug',L.P.debug);
if ~LY.isconverged
  error('FGS did not converge for FGE initialization')
end
% Restore Va and IniD from LX
LY.Va = LX.Va(:,1);
if L.np
  LY.IniD = LX.IniD(:,1);
end
%
LX = meqsk(LX,1,LY); % insert in first time slice
end

function P = replace_cde_constraint(L, P)
% For 0D cdes, this function replaces the cde degrees of freedom with
% Ip constraints in P.agcon

P.agcon = {};
% for each cde controlled domain, add Ip constraint
for ii=1:size(L.cdec, 1)
  P.agcon = [P.agcon; {'Ip', L.cdec{ii, 2}}];
end
% add all previous constraints for all domains
for iC=1:L.nC
  % Function handle can directly be used to set constraint in meqagconc
  P.agcon = [P.agcon; L.agconc(iC, 1:2)];
end
end