function dIacomp = fgeIacomp(L,dIe)
% Compute currents in compensating field coils
% to compensate for a change in Ie currents while maintaing equilibrium.
% This amounts to generating zero flux by the combination of dIe and the
% to-be-determined Icomp currents
%
% Solve LSQ problem: min || Ox.*Mxa(:,icomp) * dIacomp + Ox.*Mxa*dIe ||
% where dIacomp is nonzero only for the compensation coil set P.compa.
% Ox defines the region of interest.
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

Ox = L.Oasx(:); Ox = Ox/sum(Ox(:));

A =  Ox.* L.G.Mxa(:,L.icompa);
b = -Ox.*[L.G.Mxa,L.G.Mxu]*dIe;
dIco = A\b;

dIacomp = zeros(L.G.na,1);
dIacomp(L.icompa) = dIco;
end