function dres = fgeFJac(dx,L,xHasIy,rHasFx,...
                        ... % meqpdom jacobians
                        dF0dFx,dF1dFx,...
                        ... % Iy jacobians
                        mask,dIypdFy,dIypdF0,dIypdF1,Tyg,...
                        ... % meqagcon jacobians
                        dresdFx,dresdag,...
                        ... % meqcde jacobians
                        dcdedIy,dcdedIe,dcdedFx,dcdedF0,dcdedF1,dcdedag,...
                        ... % circuit equation jacobians
                        dcircdIy,dcircdIe)
% FGEFJAC compute action of fgeF Jacobian
%
% See also FGEF 
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

%% Extract NL unknowns
nb = size(dx,2);
dxSI = L.xscal .* dx;
if xHasIy % all-nl
  dIy = dxSI(L.ind.ixGS,:);
else % all-nl-Fx, Newton-GS
  dFx = dxSI(L.ind.ixGS,:);
end
dag =  dxSI(L.ind.ixg ,:);

if L.isEvolutive
  ixe = [L.ind.ixa,L.ind.ixu];
  dIe  = dxSI(ixe,:);
else
  dIe = zeros(L.ne,nb);
end

%% Get missing Fx or Iy
if xHasIy % all-nl
  dFx = reshape(meqFx(L,reshape(dIy,L.nzy,L.nry,nb),dIe),L.nx,nb);
else % all-nl-Fx, Newton-GS
  dIyie = L.Tye*dIe;
  dIy = -(L.dlst*dFx)./L.rhsf - dIyie;
end
% When the following flag is false, some expensive steps can be skipped 
has_dFx_or_dIy_or_dIe = any(dFx(:)) || any(dIy(:)) || any(dIe(:));

%% Plasma domain and current distribution
if has_dFx_or_dIy_or_dIe
  % Variation of limiting fluxes
  dF0 = dF0dFx*dFx;
  dF1 = dF1dFx*dFx;
  % Variation of plasma current distribution
  dFy = dFx(L.lxy,:);
  dIyp = dIypdFy.*dFy(mask,:) + dIypdF0*dF0 + dIypdF1*dF1;
end

%% GS residuals
dIy1 = Tyg*dag;
if has_dFx_or_dIy_or_dIe
  % dIyp is dense but has only rows where Opy>0
  dIy1(mask,:) = dIy1(mask,:) + dIyp;
end
if xHasIy % all-nl
  % resGS = Iy1-Iy
  dresGS = dIy1 - dIy;
elseif rHasFx % all-nl-Fx
  % resGS = Fx1-Fx
  dresGS = reshape(meqFx(L,reshape(dIy1,L.nzy,L.nry,nb),dIe),L.nx,nb) - dFx;
else % Newton-GS
  % resGS = [Fb1-Fb;L.rhsf.*(Iy1-Iy)]
  dresGS = L.Txy*(L.rhsf.*(dIy1 - dIy)) + ...
           L.Txb*(dFx(~L.lxy,:) - meqfbp(dIy1,L) - L.Mbe*dIe);
end

%% ag constraint residuals
dresag = dresdag * dag;
if has_dFx_or_dIy_or_dIe
  dresag = dresag + dresdFx * dFx;
end

%% CDE constraint residuals (if applicable)
if L.np
  drescde = dcdedag * dag;
  if has_dFx_or_dIy_or_dIe
    drescde = drescde + dcdedIy * dIy + dcdedFx * dFx + ...
                        dcdedF0 * dF0 + dcdedF1 * dF1 + ...
                        dcdedIe * dIe;
  end
else
  drescde = zeros(0,nb);
end

%% Conductor equation residuals
if L.isEvolutive
  if has_dFx_or_dIy_or_dIe
    drescirc = dcircdIy*dIy + dcircdIe*dIe;
  else
    drescirc = zeros(L.ne,nb);
  end
else
  drescirc = zeros(0,nb);
end

%% Collect and scale residuals
dres = L.resscal .* [dresGS;dresag;drescde;drescirc];

end
