function LX = fbtxtcv(t,L)
% LX = fbtxtcv(~,t,L)
% Build LX structure with FBT equilibrium definitions for TCV
% get data for fbt, take from P for now (since it is loaded from there in fbtptcv for now)
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

Pmgp = mgp(L.P.shot);
P1 = Pmgp.debug_struct(1);

% fields potentially in P1 (via MGP debug string) that belong in LX (
% (see also fbtptcv)
if L.P.idoublet
  LXagconfields = {'IpD','qA','li','bpD','bt','WkD'};
else
  LXagconfields = {'Ip','qA','li','bp','bt','Wk'};
end

for ifield = fieldnames(P1).'
  % Process time-dependent constraints
  if ismember(ifield{1},LXagconfields)
    LX.(ifield{1}) = P1.(ifield{1});
  end
end

% time-dependent parameters being passed via fbtptcv
% pfields = {'idoublet','isaddl','tol','capaj','niter'} these will be treated by fbtx
fields = {'t','Ip','qA','rBt'};

% add required fields to LX - augmenting where necessary
nt = numel(L.P.t); % time points passed from fbtptcv
for field=fieldnames(L.P)'
  myfield = field{:};
  if startsWith(myfield,'gp') % these should always have the correct size
    szt = size(L.P.(myfield),2);
    assert(any(szt == [1,nt]),sprintf('%s expected to have size nt, found %d',myfield,szt))
    LX.(myfield) = L.P.(myfield);
  elseif ismember(myfield,fields) && ~isfield(P1,myfield)
    pvalue = L.P.(myfield);
    assert(size(pvalue,2)==nt,...
      'unexpected number of time slices for %s, found %d expected %d',myfield,size(pvalue,2),nt)
    LX.(myfield) = pvalue;
  end
end

% bffbt special
isbffbt = strcmp(func2str(L.P.bfct),'bffbt'); % Only support specifying bffbt directly
if isbffbt
  % time-varying bfp added to LX
  LX.bfp = L.bfp;
end

% defaults usually not in the tree (unless passed via P.debug_p1 mechanism)
if ~isfield(L.P,'gpud'), LX.gpud = repmat(2e4,1,nt); end
if ~isfield(L.P,'gpad'), LX.gpad =        Inf(1,nt); end
if ~isfield(L.P,'gpoa'); LX.gpoa = zeros(L.G.no,nt); end  % target value for Ia constraint equations
if ~isfield(L.P,'gpoe'); LX.gpoe = zeros(L.G.no,nt); end  % exact constraints
if ~isfield(L.P,'gpod'), LX.gpod = LX.gpid;          end  % same default weight as other coil current terms

% Interpolate time indices
if ~isempty(t)
  LX = fbtxinterp(LX,t,L.P.interpx);
end

end
