function LX = fbtxcat(LX,varargin)
%FBTXCAT Concatenate FBT LX structures
% 
% Calls meqcat and then fixes NaNs in gp*e, gp*d terms
% See also MEQCAT
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

for ii=1:numel(varargin)
  LXs = varargin{ii};
  % add empty missing fields if any
  for field = setdiff(fieldnames(LX),fieldnames(LXs))'
    LXs.(field{:}) = [];
  end
  for field = setdiff(fieldnames(LXs),fieldnames(LX))'
    LX.(field{:}) = [];
  end
  % cat to LX
  LX = meqcat(LX,LXs);
end

% fix e,d fields
% fix gpb field
for field = fieldnames(LX)'
  fld = field{1};
  if strcmp(fld([1,end]),'gb') %g?b
    LX.(fld)(isnan(LX.(fld))) = false; 
  end
  if any(endsWith(fld,{'e','d'}))
    LX.(fld)(isnan(LX.(fld))) = Inf;
  end
end


end
