function varargout=fbtplot(L,LX,LY,varargin)
% fbtplot(L,LX,LY)
%
% Plotting for FBT
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

ii = find(contains(varargin(1:2:end),'parent'));
if ~isempty(ii)
  ax=varargin{2*ii}; 
  ikeep = true(size(varargin)); ikeep(2*ii+[-1,0]) = false;
  varargin = varargin(ikeep);
else
  ax = gca;
end

if L.P.izgrid
  hax = meqplotfancy(L,LY,'fillPlasma',false,'parent',ax);
else
  hax = meqplott(L,LY,'parent',ax); 
end
hold(hax,'on');
% plot one contour on FBT flux offset value from optimizer
contour(hax,L.rx,L.zx,LY.Fx,LY.Fb*[1 1],'b--','linewidth',2)
fbtxplot(L,LX,'parent',hax,varargin{:});
if nargout>0
  varargout{1}=hax;
end
end