%FBTPANA  ANA FBT configuration parameters
% P = FBTPANA(SHOT,'PAR',VAL,...) returns a structure P with configuration
% parameters for ANA tokamak, optionally replacing or adding
% parameters with specified values. See also FBTP.
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
function P = fbtpana(shot,varargin)
 
 % defaults for ana
 P = meqpana(shot);

 % overwrite P.nc from user arguments in case it's passed
 inc = find(contains(varargin(1:2:end),'nc'));
 if ~isempty(inc)
   P.nc = varargin{2*inc};
 end

 % customize
 P.tol    = 1e-6;
 P.useSQP = true; % Enable Newton method instead of Picard iterations
 
 % Coil current constraints
 Imax = Inf; % default 0 no constraint
 nc = P.nc + P.fastcoil;
 P.limc = eye(nc);
 P.limu = repmat(+Imax,nc,1);
 P.liml = repmat(-Imax,nc,1);
 
 % Plasma constraints
 if shot == 88
   P.fbtagcon = {{'Ip','Wk','qA'},{'Ip','Wk','qA'},{'Ip','Wk'}};
 end

 % adds/overwrites parameters
 for k = 1:2:nargin-1
   P.(varargin{k}) = varargin{k+1};
 end
 
 % checks
 legacy_fields = {'Ip','qA','li','bp','bpD','IpD','bt'};
 ioffending = isfield(P,legacy_fields);
 assert(~any(ioffending),...
   'Passing fields P.%s is deprecated, must pass directly through LX\n',legacy_fields{ioffending})
 
 assert(size(P.limc,2)==nc,'fbtpana:limcSize','limc is of the wrong size, must have P.nc+P.fastcoil=%d columns',nc);
 assert(size(P.limc,1)==numel(P.limu),'fbtpana:limuSize','limu is of the wrong size, must have same number of rows as limc (%d)',size(P.limc,1));
 assert(size(P.limc,1)==numel(P.liml),'fbtpana:limlSize','liml is of the wrong size, must have same number of rows as limc (%d)',size(P.limc,1));
 
end
