function LX = fbtgpclear(LX)
% Clear control points from FBT LX structure
% Replaces control point fields usually set by fbtgp by empty fields with
% second dimension matching number of time points
%
% See also FBTGP
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

if nargin==0
  LX = struct();
  return
end

nt = numel(LX.t);
for derorder = 0:2
  switch derorder
    case 0, gp='gp';
    case 1, gp='g1';
    case 2, gp='g2';
  end
  
  for flds = {'r','z','b',...
      'fa','fb','fe',...
      'br','bz','ba','be',...
      'cr','cz','ca','ce',...
      'vrr','vrz','vzz','ve'}
    field = [gp,flds{:}];
    if isfield(LX,field)
      LX.(field) = zeros(0,nt);
    end
  end
end
end