%FBTG  FBTE geometry and electromagnetic parameters
% G = FBTG(G,P) defines missing fields in the structure G using parameters
% in structure P. See also MEQG.
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
function G = fbtg(G,P,xargs)

if nargin<3, xargs={}; end

if P.circuit
   xargs = [xargs,{'Maa','Ra','Mau','Muu','Ru'}];
end

G = meqg(G,P,xargs{:});

% defaults for Ia linear constraints
if ~isfield(G,'Coa')
  G.Coa = zeros(0,G.na);
end
if ~isfield(G,'no')
  G.no = size(G.Coa,1);
end

end
