%FBTE  TCV FBTE equilibrium calculation
% [L,LX,LY] = FBTE(SHOT,'PAR',VAL,...) calls FBT('TCV',SHOT,...) and writes
% results in PCS tree. See also FBT.
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
function varargout = fbte(shot,varargin)
 
 [varargout{1:nargout}] = fbt('TCV',shot,[],'LYall',true,varargin{:});
 if nargout > 2 && (shot == -1 || (shot >= 9e5 && shot <1e6))
  L  = varargout{1};
  LY = varargout{3};
  psiwtcv(shot,'PCS','\TOP.MGAMS.EQUIL',L,LY)
  meqwtcv(shot,'PCS','\TOP.MGAMS.EQUIL',L,LY)
  fbtwtcv(shot,'PCS','\TOP'            ,L,LY) % old style nodes
  % codwtcv(shot,'PCS',,'FBTE.M','Standard FBTE.M run') % No nodes yet for this
 end
 
end
