function GP=fbtLX2GP(LX,derorder)
% Helper function to get GP (FBT constraint variables) for a given order
% from an FBT LX structure.
%
% See MEQLSQPREP, FBTOPT
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

switch derorder
  case 0, gp = 'gp';
  otherwise, gp = ['g',num2str(derorder)];
end
% find LX fields matching pattern
LXfields = fieldnames(LX)';
GPfields = LXfields(startsWith(LXfields,gp));
GP = struct();

if isempty(GPfields) % no fields
  return
end

for gnfld=GPfields
  % convert g1*,g2* to gp* equivalent
  gpfld = ['gp',gnfld{:}(3:end)];
  GP.(gpfld) = LX.(gnfld{:});
end

% also add time
GP.t = LX.t;
end
