%FBT  FBT top level function
%
% [L,LX,LY] = FBT('TOK',SHOT,T,'PAR',VAL,...) is the top level function to
% calculate FBT equilibria for TOK SHOT, optionally replacing or adding
% parameters with specified values. T is optional and may be set as empty
%
% L = FBT('TOK',SHOT,...) returns only the pre-computed quantities as provided by 
% FBTP<TOK>, FBTG<TOK> and FBTC for later use.
% [L,LX] = FBT('TOK',SHOT,...) additionally returns the data in LX
% generated from FBTX<TOK>
%
% For general help,see README.MD and MEQHELP
% For general help on FBT, see FBTHELP and FBTGP
% For help on LY,  see MEQT and FBTT
% For help on LX,  see FBTX and FBTX<TOK>
% For help on L.P, see MEQP, MEQP<TOK>, FBTP and FBTP<TOK> 
% For help on L.G, see MEQG, MEQG<TOK>, FBTG and FBTG<TOK> 
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

function [L,LX,LY] = fbt(tok,shot,t,varargin)
 assert(ischar(tok),'tok must be a string')
 tok = lower(tok);
 meqpath(mfilename,tok); % check required files and add path if necessary
 
 assert(isnumeric(shot),'shot must be a number');
 if nargin<3, t=[]; else, assert(isnumeric(t) || isempty(t),'t must be numeric or empty'); end
 assert(~isodd(numel(varargin)),'varargin must come in parameter-value pairs')
 
 % Tokamak specific functions
 fbtptok = str2func(['fbtp' tok]);
 fbtgtok = str2func(['fbtg' tok]);
 fbtxtok = str2func(['fbtx' tok]);

 % Algorithm configuration parameters, geometry and anciliary data
 P = fbtptok(shot,varargin{:});
 G = fbtgtok(shot,P);
 P = fbtp(P);
 G = fbtg(G,P);
 L = fbtc(P,G);
 
 if nargout > 1
   assert(isnumeric(t) || isempty(t),'t must be numeric or empty');
   LX = fbtxtok(t,L);
   LX = fbtx(L,LX);
 end
 
 if nargout > 2
  LY = fbtt(L,LX);
 end
 
end
