%FBNDMEX  Find LCFS
% [FB,RB,ZB,LB,LX,kB] = FBNDMEX(FL,RL,ZL,FX,RX,ZX,FN) finds the flux FB and
% the limiting point (RB,ZB) of the LCFS. FL is the flux on the limiter
% points (RL,ZL), FX the flux of the X-points (RX,ZX). FN, e.g. -Inf*Ip,
% flags in FL and FX non valid entries. For Ip>0, FN<0, FB = max([FL FX]),
% for Ip<0, FN>0, FB = min([FL FX]). LB is FALSE if no valid point is
% found. LX is TRUE if an X-point defines the LCFS. KB is the index of the
% active X-point if LX is true or of the limiter point otherwise.
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

function varargout = fbndmex(varargin) %#ok<STOUT>
 error('MEQ:MEX "%s" not compiled or not in the Matlab path',mfilename)
end
