function dispparams(P)
% Helper function to display parameter structures
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

for field = fieldnames(P)'
  val = P.(field{:});
  % remove large numeric fields since these are not well displayed by
  % disp() in octave
  if isnumeric(val) && numel(val)>10
    P = rmfield(P,field{:});
    fprintf('%19s: size = %s, class = %s\n',field{:},mat2str(size(val)),class(val));
  end
end
% then display what is left
disp(P);
end