function vessel_data = JT60SA_vessel_data()
% Plasma facing line of First Wall and Divertor						
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.


rin = [ ...
2.8655
    2.5640
    2.2555
    1.9710
    1.7550
    1.6440
    1.6180
    1.6180
    1.6180
    1.6180
    1.6180
    1.6180
    1.6180
    1.6180
    1.6180
    1.6180
    1.6180
    1.6180
    1.6180
    1.6180
    1.6180
    1.6460
    1.7600
    1.9780
    2.2640
    2.5730
    2.8740
    3.1530
    3.4105
    3.6495
    3.8685
    4.0670
    4.2425
    4.3930
    4.5175
    4.6155
    4.6865
    4.7285
    4.7425
    4.7275
    4.6835
    4.6120
    4.5130
    4.3865
    4.2340
    4.0585
    3.8610
    3.6425
    3.4035
    3.1455];

zin = [ ...
-3.0365
   -3.1135
   -3.1115
   -3.0035
   -2.7900
   -2.5065
   -2.1960
   -1.8820
   -1.5685
   -1.2550
   -0.9415
   -0.6280
   -0.3145
   -0.0010
    0.3130
    0.6265
    0.9400
    1.2535
    1.5670
    1.8805
    2.1940
    2.5040
    2.7865
    2.9980
    3.1020
    3.1010
    3.0220
    2.8830
    2.7045
    2.5025
    2.2790
    2.0365
    1.7775
    1.5030
    1.2155
    0.9185
    0.6135
    0.3030
   -0.0095
   -0.3220
   -0.6320
   -0.9370
   -1.2340
   -1.5205
   -1.7945
   -2.0535
   -2.2965
   -2.5210
   -2.7230
   -2.9000];

rout=[...
2.8580
    2.5310
    2.1995
    1.8920
    1.6460
    1.4965
    1.4460
    1.4420
    1.4420
    1.4420
    1.4420
    1.4420
    1.4420
    1.4420
    1.4420
    1.4420
    1.4420
    1.4420
    1.4420
    1.4420
    1.4525
    1.5260
    1.7030
    1.9680
    2.2860
    2.6190
    2.9420
    3.2435
    3.5235
    3.7840
    4.0235
    4.2400
    4.4310
    4.5950
    4.7305
    4.8355
    4.9100
    4.9535
    4.9655
    4.9455
    4.8940
    4.8110
    4.6970
    4.5540
    4.3825
    4.1850
    3.9625
    3.7170
    3.4510
    3.1655
];


zout=[...
-3.2185
   -3.2880
   -3.2745
   -3.1555
   -2.9365
   -2.6440
   -2.3150
   -1.9785
   -1.6415
   -1.3045
   -0.9675
   -0.6310
   -0.2945
    0.0425
    0.3795
    0.7165
    1.0530
    1.3895
    1.7265
    2.0635
    2.3995
    2.7220
    2.9995
    3.1940
    3.2820
    3.2720
    3.1860
    3.0400
    2.8540
    2.6415
    2.4055
    2.1480
    1.8710
    1.5775
    1.2700
    0.9510
    0.6230
    0.2895
   -0.0465
   -0.3820
   -0.7140
   -1.0400
   -1.3565
   -1.6610
   -1.9505
   -2.2225
   -2.4745
   -2.7040
   -2.9095
   -3.0865];

 
vessel_data.in.r = rin;
vessel_data.in.z = zin;
vessel_data.in.thick = 0.018;
vessel_data.in.R = 0.72;
vessel_data.in.unit_thick = '[m]';
vessel_data.in.unit_R = '[mu Omega m]';


vessel_data.out.r = rout;
vessel_data.out.z = zout;
vessel_data.out.thick = 0.018;
vessel_data.out.R = 0.72;
vessel_data.out.unit_thick = '[m]';
vessel_data.out.unit_R = '[mu Omega m]';


end
